/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.tms;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidationResult;
import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.DocumentValidatorImpl;
import com.fifa.connectid.sdk.core.apimodelvalidation.PdfValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.PictureValidator;
import com.fifa.fc.DocumentEmbeddedType;
import com.fifa.fc.DomesticTransferDeclaration;
import com.fifa.fc.SellOnFeeType;

public class DomesticTransferDeclarationValidator {
    private static final DocumentValidator validator = new DocumentValidatorImpl(new PictureValidator(), new PdfValidator());

    public static void validate(DomesticTransferDeclaration domesticTransferDeclaration) throws ValidationException {
        if (domesticTransferDeclaration.getMessageId() == null) {
            throw new ValidationException("MessageId is missing");
        }
        DomesticTransferDeclarationValidator.validateIfNotNull(domesticTransferDeclaration.getTransferCertificate());
        DomesticTransferDeclarationValidator.validateIfNotNull(domesticTransferDeclaration.getTransferAgreement());
        if (domesticTransferDeclaration.getResidencePermit() != null) {
            DomesticTransferDeclarationValidator.validateIfNotNull(domesticTransferDeclaration.getResidencePermit().getResidencePermitDocument());
        }
        if (domesticTransferDeclaration.getWorkPermit() != null) {
            DomesticTransferDeclarationValidator.validateIfNotNull(domesticTransferDeclaration.getWorkPermit().getWorkPermitDocument());
        }
        if (domesticTransferDeclaration.getSellOnFee() == null) {
            throw new ValidationException("Sell-on fee is missing");
        }
        DomesticTransferDeclarationValidator.validateIfAnyFeeIsPresent(domesticTransferDeclaration);
    }

    private static void validateIfAnyFeeIsPresent(DomesticTransferDeclaration domesticTransferDeclaration) throws ValidationException {
        if (domesticTransferDeclaration.getSellOnFee() == SellOnFeeType.YES) {
            return;
        }
        if (!(domesticTransferDeclaration.getConditionalTransferFees().isEmpty() && domesticTransferDeclaration.getFixedTransferFees().isEmpty() && domesticTransferDeclaration.getReleaseBuyoutFees().isEmpty())) {
            return;
        }
        throw new ValidationException("At least one fee (Sell-on, Fixed, Conditional or Buy-out) must be specified");
    }

    private static void validateIfNotNull(DocumentEmbeddedType document) throws ValidationException {
        DocumentValidationResult result;
        if (document != null && !(result = validator.validate(document.getValue())).isValid()) {
            throw new ValidationException(result.getMessage());
        }
    }
}

