/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.tms;

import com.fifa.connectid.sdk.core.SdkVersionHelper;
import com.fifa.connectid.sdk.core.XmlSerializationException;
import com.fifa.connectid.sdk.core.exceptions.TmsOperationException;
import com.fifa.connectid.sdk.core.xmlserializer.XmlSerializer;
import com.fifa.connectid.sdk.tms.RequestValidator;
import com.fifa.connectid.sdk.util.CorrelationIdFormatter;
import com.fifa.connectid.sdk.util.PrefixedLogger;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

class TmsOperation<Request> {
    private static final String TMS_RECIPIENT = "105C3ZB_TMS";
    private final FifaConnectServiceBusClient fifaConnectServiceBusClient;
    private final RequestValidator<Request> requestValidator;
    private final XmlSerializer<Request> requestXmlSerializer;
    private final Function<Request, String> requestToString;
    private final Logger logger;

    public TmsOperation(FifaConnectServiceBusClient fifaConnectServiceBusClient, RequestValidator<Request> requestValidator, XmlSerializer<Request> requestXmlSerializer, Function<Request, String> requestToString, Logger logger) {
        this.fifaConnectServiceBusClient = fifaConnectServiceBusClient;
        this.requestValidator = requestValidator;
        this.requestXmlSerializer = requestXmlSerializer;
        this.requestToString = requestToString;
        this.logger = logger;
    }

    public void sendRequest(String correlationId, String requestType, Request request) throws TmsOperationException {
        try {
            PrefixedLogger requestLogger = new PrefixedLogger(this.logger, CorrelationIdFormatter.format(correlationId) + String.format("[ReqType: %s] [Req: %s] ", requestType, this.requestToString.apply(request)));
            this.requestValidator.validate(requestType, request);
            requestLogger.debug("Sending...", new Object[0]);
            this.sendMessage(requestType, correlationId, request);
            requestLogger.debug("Sent.", new Object[0]);
        }
        catch (Exception ex) {
            throw new TmsOperationException("An issue occurred when trying to send the request.", ex);
        }
    }

    private void sendMessage(String requestType, String correlationId, Request request) throws FifaConnectServiceBusException, JAXBException, IOException, XmlSerializationException, SAXException {
        String xml = this.requestXmlSerializer.serialize(request);
        Map<String, String> properties = TmsOperation.getMessageProperties(correlationId);
        byte[] content = xml.getBytes(StandardCharsets.UTF_8);
        this.fifaConnectServiceBusClient.send(TMS_RECIPIENT, content, requestType, properties);
    }

    private static Map<String, String> getMessageProperties(String correlationId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("correlationId", correlationId);
        properties.put("version", SdkVersionHelper.GetTechnologyWithVersion());
        return properties;
    }
}

