<?php
/**
 * CertificateApi
 * PHP version 5
 *
 * @category Class
 * @package  Fifa\ConnectServiceBus\Sdk\Api
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * FIFA Connect Service Bus - V3
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Fifa\ConnectServiceBus\Sdk\Api\Resource;

use \Fifa\ConnectServiceBus\Sdk\Api\ApiClient;
use \Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use \Fifa\ConnectServiceBus\Sdk\Api\Configuration;
use \Fifa\ConnectServiceBus\Sdk\Api\ObjectSerializer;

/**
 * CertificateApi Class Doc Comment
 *
 * @category Class
 * @package  Fifa\ConnectServiceBus\Sdk\Api
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CertificateApi
{
    /**
     * API Client
     *
     * @var \Fifa\ConnectServiceBus\Sdk\Api\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Fifa\ConnectServiceBus\Sdk\Api\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Fifa\ConnectServiceBus\Sdk\Api\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Fifa\ConnectServiceBus\Sdk\Api\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Fifa\ConnectServiceBus\Sdk\Api\ApiClient $apiClient set the API client
     *
     * @return CertificateApi
     */
    public function setApiClient(\Fifa\ConnectServiceBus\Sdk\Api\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation certificateDownloadByQueueidentifier
     *
     * Gets a byte array that contains data from an X.509 certificate for a given queue.
     *
     * @param string $queue_identifier FIFA Unique Identifier with possible system name suffix (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return object
     */
    public function certificateDownloadByQueueidentifier($queue_identifier)
    {
        list($response) = $this->certificateDownloadByQueueidentifierWithHttpInfo($queue_identifier);
        return $response;
    }

    /**
     * Operation certificateDownloadByQueueidentifierWithHttpInfo
     *
     * Gets a byte array that contains data from an X.509 certificate for a given queue.
     *
     * @param string $queue_identifier FIFA Unique Identifier with possible system name suffix (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function certificateDownloadByQueueidentifierWithHttpInfo($queue_identifier)
    {
        // verify the required parameter 'queue_identifier' is set
        if ($queue_identifier === null) {
            throw new \InvalidArgumentException('Missing the required parameter $queue_identifier when calling certificateDownloadByQueueidentifier');
        }
        // parse inputs
        $resourcePath = "/api/v3/certificate/download";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($queue_identifier !== null) {
            $queryParams['queueIdentifier'] = $this->apiClient->getSerializer()->toQueryValue($queue_identifier);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                'object',
                '/api/v3/certificate/download'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, 'object', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation certificateUploadByRawdata
     *
     * Uploads a public certificate to Connect Service Bus.
     *
     * @param string $raw_data A byte array that contains data for an X.509 certificate. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function certificateUploadByRawdata($raw_data)
    {
        list($response) = $this->certificateUploadByRawdataWithHttpInfo($raw_data);
        return $response;
    }

    /**
     * Operation certificateUploadByRawdataWithHttpInfo
     *
     * Uploads a public certificate to Connect Service Bus.
     *
     * @param string $raw_data A byte array that contains data for an X.509 certificate. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function certificateUploadByRawdataWithHttpInfo($raw_data)
    {
        // verify the required parameter 'raw_data' is set
        if ($raw_data === null) {
            throw new \InvalidArgumentException('Missing the required parameter $raw_data when calling certificateUploadByRawdata');
        }
        // parse inputs
        $resourcePath = "/api/v3/certificate/upload";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json', 'text/json', 'application/octet-stream']);

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($raw_data)) {
            $_tempBody = $raw_data;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/certificate/upload'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
