<?php
/**
 * MessageApi
 * PHP version 5
 *
 * @category Class
 * @package  Fifa\ConnectServiceBus\Sdk\Api
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * FIFA Connect Service Bus - V3
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: v3
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Fifa\ConnectServiceBus\Sdk\Api\Resource;

use \Fifa\ConnectServiceBus\Sdk\Api\ApiClient;
use \Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use \Fifa\ConnectServiceBus\Sdk\Api\Configuration;
use \Fifa\ConnectServiceBus\Sdk\Api\ObjectSerializer;

/**
 * MessageApi Class Doc Comment
 *
 * @category Class
 * @package  Fifa\ConnectServiceBus\Sdk\Api
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class MessageApi
{
    /**
     * API Client
     *
     * @var \Fifa\ConnectServiceBus\Sdk\Api\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \Fifa\ConnectServiceBus\Sdk\Api\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\Fifa\ConnectServiceBus\Sdk\Api\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \Fifa\ConnectServiceBus\Sdk\Api\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \Fifa\ConnectServiceBus\Sdk\Api\ApiClient $apiClient set the API client
     *
     * @return MessageApi
     */
    public function setApiClient(\Fifa\ConnectServiceBus\Sdk\Api\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation messageCreateTopicByTopicnameAndShardnumber
     *
     * Creates a new topic for messages.
     *
     * @param string $topic_name The name of the topic to be created. (required)
     * @param int $shard_number Number of shard (optional)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return \Fifa\ConnectServiceBus\Sdk\Api\Model\Object
     */
    public function messageCreateTopicByTopicnameAndShardnumber($topic_name, $shard_number = null)
    {
        list($response) = $this->messageCreateTopicByTopicnameAndShardnumberWithHttpInfo($topic_name, $shard_number);
        return $response;
    }

    /**
     * Operation messageCreateTopicByTopicnameAndShardnumberWithHttpInfo
     *
     * Creates a new topic for messages.
     *
     * @param string $topic_name The name of the topic to be created. (required)
     * @param int $shard_number Number of shard (optional)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of \Fifa\ConnectServiceBus\Sdk\Api\Model\Object, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageCreateTopicByTopicnameAndShardnumberWithHttpInfo($topic_name, $shard_number = null)
    {
        // verify the required parameter 'topic_name' is set
        if ($topic_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $topic_name when calling messageCreateTopicByTopicnameAndShardnumber');
        }
        // parse inputs
        $resourcePath = "/api/v3/message/createtopic";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($topic_name !== null) {
            $queryParams['topicName'] = $this->apiClient->getSerializer()->toQueryValue($topic_name);
        }
        // query params
        if ($shard_number !== null) {
            $queryParams['shardNumber'] = $this->apiClient->getSerializer()->toQueryValue($shard_number);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\Fifa\ConnectServiceBus\Sdk\Api\Model\Object',
                '/api/v3/message/createtopic'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\Fifa\ConnectServiceBus\Sdk\Api\Model\Object', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\Object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageDeleteByRequestMessageidAndRequestLocktoken
     *
     * Deletes a previously locked message (see PeekLock method).
     *
     * @param string $message_id Message identifier returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @param string $lock_token Lock token, returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function messageDeleteByRequestMessageidAndRequestLocktoken($message_id, $lock_token)
    {
        list($response) = $this->messageDeleteByRequestMessageidAndRequestLocktokenWithHttpInfo($message_id, $lock_token);
        return $response;
    }

    /**
     * Operation messageDeleteByRequestMessageidAndRequestLocktokenWithHttpInfo
     *
     * Deletes a previously locked message (see PeekLock method).
     *
     * @param string $message_id Message identifier returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @param string $lock_token Lock token, returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageDeleteByRequestMessageidAndRequestLocktokenWithHttpInfo($message_id, $lock_token)
    {
        // verify the required parameter 'message_id' is set
        if ($message_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $message_id when calling messageDeleteByRequestMessageidAndRequestLocktoken');
        }
        // verify the required parameter 'lock_token' is set
        if ($lock_token === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lock_token when calling messageDeleteByRequestMessageidAndRequestLocktoken');
        }
        // parse inputs
        $resourcePath = "/api/v3/message/delete";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($message_id !== null) {
            $queryParams['messageId'] = $this->apiClient->getSerializer()->toQueryValue($message_id);
        }
        // query params
        if ($lock_token !== null) {
            $queryParams['lockToken'] = $this->apiClient->getSerializer()->toQueryValue($lock_token);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/message/delete'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageDeleteTemporaryTopics
     *
     * 
     *
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function messageDeleteTemporaryTopics()
    {
        list($response) = $this->messageDeleteTemporaryTopicsWithHttpInfo();
        return $response;
    }

    /**
     * Operation messageDeleteTemporaryTopicsWithHttpInfo
     *
     * 
     *
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageDeleteTemporaryTopicsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v3/message/deletetemporarytopics";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/message/deletetemporarytopics'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageDeleteTopicByTopicname
     *
     * Deletes topic for messages
     *
     * @param string $topic_name  (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function messageDeleteTopicByTopicname($topic_name)
    {
        list($response) = $this->messageDeleteTopicByTopicnameWithHttpInfo($topic_name);
        return $response;
    }

    /**
     * Operation messageDeleteTopicByTopicnameWithHttpInfo
     *
     * Deletes topic for messages
     *
     * @param string $topic_name  (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageDeleteTopicByTopicnameWithHttpInfo($topic_name)
    {
        // verify the required parameter 'topic_name' is set
        if ($topic_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $topic_name when calling messageDeleteTopicByTopicname');
        }
        // parse inputs
        $resourcePath = "/api/v3/message/deletetopic";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($topic_name !== null) {
            $queryParams['topicName'] = $this->apiClient->getSerializer()->toQueryValue($topic_name);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/message/deletetopic'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messagePeekLockByRequestTimeout
     *
     * Gets and locks a message without deleting it from the queue. If message is not deleted within configured time it's automatically unlocked and visible for other recipients.
     *
     * @param int $timeout The system will wait N number of seconds before returning \&quot;no messages available\&quot; message. (optional, default to 60)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return object
     */
    public function messagePeekLockByRequestTimeout($timeout = null)
    {
        list($response) = $this->messagePeekLockByRequestTimeoutWithHttpInfo($timeout);
        return $response;
    }

    /**
     * Operation messagePeekLockByRequestTimeoutWithHttpInfo
     *
     * Gets and locks a message without deleting it from the queue. If message is not deleted within configured time it's automatically unlocked and visible for other recipients.
     *
     * @param int $timeout The system will wait N number of seconds before returning \&quot;no messages available\&quot; message. (optional, default to 60)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function messagePeekLockByRequestTimeoutWithHttpInfo($timeout = null)
    {
        if (!is_null($timeout) && ($timeout > 60)) {
            throw new \InvalidArgumentException('invalid value for "$timeout" when calling MessageApi.messagePeekLockByRequestTimeout, must be smaller than or equal to 60.');
        }
        if (!is_null($timeout) && ($timeout < 1)) {
            throw new \InvalidArgumentException('invalid value for "$timeout" when calling MessageApi.messagePeekLockByRequestTimeout, must be bigger than or equal to 1.');
        }

        // parse inputs
        $resourcePath = "/api/v3/message/peeklock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($timeout !== null) {
            $queryParams['timeout'] = $this->apiClient->getSerializer()->toQueryValue($timeout);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                'object',
                '/api/v3/message/peeklock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, 'object', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageReceiveByRequestTimeout
     *
     * Gets a message from the Message Bus. Message is deleted from the queue.
     *
     * @param int $timeout The system will wait N number of seconds before returning \&quot;no messages available\&quot; message. (optional, default to 60)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return object
     */
    public function messageReceiveByRequestTimeout($timeout = null)
    {
        list($response) = $this->messageReceiveByRequestTimeoutWithHttpInfo($timeout);
        return $response;
    }

    /**
     * Operation messageReceiveByRequestTimeoutWithHttpInfo
     *
     * Gets a message from the Message Bus. Message is deleted from the queue.
     *
     * @param int $timeout The system will wait N number of seconds before returning \&quot;no messages available\&quot; message. (optional, default to 60)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageReceiveByRequestTimeoutWithHttpInfo($timeout = null)
    {
        if (!is_null($timeout) && ($timeout > 60)) {
            throw new \InvalidArgumentException('invalid value for "$timeout" when calling MessageApi.messageReceiveByRequestTimeout, must be smaller than or equal to 60.');
        }
        if (!is_null($timeout) && ($timeout < 1)) {
            throw new \InvalidArgumentException('invalid value for "$timeout" when calling MessageApi.messageReceiveByRequestTimeout, must be bigger than or equal to 1.');
        }

        // parse inputs
        $resourcePath = "/api/v3/message/receive";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($timeout !== null) {
            $queryParams['timeout'] = $this->apiClient->getSerializer()->toQueryValue($timeout);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                'object',
                '/api/v3/message/receive'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, 'object', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'object', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageRenewLockByRequestMessageidAndRequestLocktoken
     *
     * Extends the lock time for the previously locked message (see PeekLock method).
     *
     * @param string $message_id Message identifier returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @param string $lock_token Lock token, returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function messageRenewLockByRequestMessageidAndRequestLocktoken($message_id, $lock_token)
    {
        list($response) = $this->messageRenewLockByRequestMessageidAndRequestLocktokenWithHttpInfo($message_id, $lock_token);
        return $response;
    }

    /**
     * Operation messageRenewLockByRequestMessageidAndRequestLocktokenWithHttpInfo
     *
     * Extends the lock time for the previously locked message (see PeekLock method).
     *
     * @param string $message_id Message identifier returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @param string $lock_token Lock token, returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageRenewLockByRequestMessageidAndRequestLocktokenWithHttpInfo($message_id, $lock_token)
    {
        // verify the required parameter 'message_id' is set
        if ($message_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $message_id when calling messageRenewLockByRequestMessageidAndRequestLocktoken');
        }
        // verify the required parameter 'lock_token' is set
        if ($lock_token === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lock_token when calling messageRenewLockByRequestMessageidAndRequestLocktoken');
        }
        // parse inputs
        $resourcePath = "/api/v3/message/renewlock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($message_id !== null) {
            $queryParams['messageId'] = $this->apiClient->getSerializer()->toQueryValue($message_id);
        }
        // query params
        if ($lock_token !== null) {
            $queryParams['lockToken'] = $this->apiClient->getSerializer()->toQueryValue($lock_token);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/message/renewlock'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageSendByRecipientAndBodyAndActionAndProperties
     *
     * Sends a message to a specified recipient via Message Bus.
     *
     * @param string $recipient Recipient, usually MA to receive the message. (required)
     * @param string $body Message body (required)
     * @param string $x_action Name of the action. Optional parameter (optional)
     * @param string $x_properties Unencrypted properties of the message. Optional parameter (optional)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function messageSendByRecipientAndBodyAndActionAndProperties($recipient, $body, $x_action = null, $x_properties = null)
    {
        list($response) = $this->messageSendByRecipientAndBodyAndActionAndPropertiesWithHttpInfo($recipient, $body, $x_action, $x_properties);
        return $response;
    }

    /**
     * Operation messageSendByRecipientAndBodyAndActionAndPropertiesWithHttpInfo
     *
     * Sends a message to a specified recipient via Message Bus.
     *
     * @param string $recipient Recipient, usually MA to receive the message. (required)
     * @param string $body Message body (required)
     * @param string $x_action Name of the action. Optional parameter (optional)
     * @param string $x_properties Unencrypted properties of the message. Optional parameter (optional)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageSendByRecipientAndBodyAndActionAndPropertiesWithHttpInfo($recipient, $body, $x_action = null, $x_properties = null)
    {
        // verify the required parameter 'recipient' is set
        if ($recipient === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient when calling messageSendByRecipientAndBodyAndActionAndProperties');
        }
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling messageSendByRecipientAndBodyAndActionAndProperties');
        }
        // parse inputs
        $resourcePath = "/api/v3/message/send";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/json', 'text/json', 'application/octet-stream']);

        // query params
        if ($recipient !== null) {
            $queryParams['recipient'] = $this->apiClient->getSerializer()->toQueryValue($recipient);
        }
        // header params
        if ($x_action !== null) {
            $headerParams['X-Action'] = $this->apiClient->getSerializer()->toHeaderValue($x_action);
        }
        // header params
        if ($x_properties !== null) {
            $headerParams['X-Properties'] = $this->apiClient->getSerializer()->toHeaderValue($x_properties);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/message/send'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation messageUnlockByRequestMessageidAndRequestLocktoken
     *
     * Unlocks a previously locked message. The message is returned to the queue and can be fetched using PeekLock or Receive method.
     *
     * @param string $message_id Message identifier returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @param string $lock_token Lock token, returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return void
     */
    public function messageUnlockByRequestMessageidAndRequestLocktoken($message_id, $lock_token)
    {
        list($response) = $this->messageUnlockByRequestMessageidAndRequestLocktokenWithHttpInfo($message_id, $lock_token);
        return $response;
    }

    /**
     * Operation messageUnlockByRequestMessageidAndRequestLocktokenWithHttpInfo
     *
     * Unlocks a previously locked message. The message is returned to the queue and can be fetched using PeekLock or Receive method.
     *
     * @param string $message_id Message identifier returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @param string $lock_token Lock token, returned by a previously called \&quot;peeklock\&quot; method. (required)
     * @throws \Fifa\ConnectServiceBus\Sdk\Api\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function messageUnlockByRequestMessageidAndRequestLocktokenWithHttpInfo($message_id, $lock_token)
    {
        // verify the required parameter 'message_id' is set
        if ($message_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $message_id when calling messageUnlockByRequestMessageidAndRequestLocktoken');
        }
        // verify the required parameter 'lock_token' is set
        if ($lock_token === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lock_token when calling messageUnlockByRequestMessageidAndRequestLocktoken');
        }
        // parse inputs
        $resourcePath = "/api/v3/message/unlock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json', 'text/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        // query params
        if ($message_id !== null) {
            $queryParams['messageId'] = $this->apiClient->getSerializer()->toQueryValue($message_id);
        }
        // query params
        if ($lock_token !== null) {
            $queryParams['lockToken'] = $this->apiClient->getSerializer()->toQueryValue($lock_token);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v3/message/unlock'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
