<?php
namespace Fifa\ConnectServiceBus\Sdk\Authentication;

/**
 * Interface CacheStorageInterface
 * @package Fifa\ConnectServiceBus\Sdk\Authentication
 */
interface CacheStorageInterface
{
    /**
     * Method stores serialized data in cache system.
     *
     * @param mixed $object
     * @param string $cacheId
     */
    public function put($object, $cacheId);

    /**
     * Method returns serialized data from cache system.
     *
     * @param string $cacheId
     * @return mixed|null
     */
    public function get($cacheId);
}