<?php
namespace Fifa\ConnectServiceBus\Sdk\Authentication\Model;
use Fifa\ConnectServiceBus\Sdk\Authentication\AuthenticationResourceBuilderInterface;

/**
 * Class AuthenticationInformation
 * @package Fifa\ConnectServiceBus\Sdk\Authentication\Model
 */
class AuthenticationInformation
{
    /**
     * @var string
     */
    private $resourceUri;

    /**
     * @var string
     */
    private $clientId;

    /**
     * @var string
     */
    private $secretKey;

    /**
     * @var string
     */
    private $tenant;

    /**
     * Constructor
     *
     * @param AuthenticationResourceBuilderInterface $resourceBuilder
     * @param ClientCredentials $clientCredentials
     * @param string $serviceUri
     * @param string $tenant
     */
    public function __construct(AuthenticationResourceBuilderInterface $resourceBuilder, ClientCredentials $clientCredentials, $serviceUri, $tenant)
    {
        $this->resourceUri = $resourceBuilder->buildResourceUri($serviceUri, $tenant);
        $this->clientId = $clientCredentials->getClientId();
        $this->secretKey = $clientCredentials->getSecretKey();
        $this->tenant = $tenant;
    }

    /**
     * String representation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return  'Resource: ' . $this->getResourceUri() . ', ClientId: ' . $this->getClientId() . ', Tenant: ' . $this->getTenant();
    }

    /**
     * Getter for resource
     *
     * @return string
     */
    public function getResourceUri()
    {
        return $this->resourceUri;
    }

    /**
     * Getter for ClientId
     *
     * @return string
     */
    public function getClientId()
    {
        return $this->clientId;
    }

    /**
     * Getter for SecretKey
     *
     * @return string
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }

    /**
     * Getter for Tenant
     *
     * @return string
     */
    public function getTenant()
    {
        return $this->tenant;
    }
}