<?php
namespace Fifa\ConnectServiceBus\Sdk\Authentication\Model;

/**
 * Class ClientCredentials
 * @package Fifa\ConnectServiceBus\Sdk\Authentication\Model
 */
class ClientCredentials
{
    /**
     * @var string
     */
    private $clientId;

    /**
     * @var string
     */
    private $secretKey;

    /**
     * Constructor
     *
     * @param $clientId
     * @param $secretKey
     */
    public function __construct($clientId, $secretKey)
    {
        if (strlen($clientId) === 0 || is_null($clientId)) {
            throw new \InvalidArgumentException('$clientId cannot be empty');
        }

        if (strlen($secretKey) === 0 || is_null($secretKey)) {
            throw new \InvalidArgumentException('$secretKey cannot be empty');
        }

        $this->secretKey = $secretKey;
        $this->clientId = $clientId;
    }

    /**
     * Returns string representation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return 'ClientId: ' . $this->getClientId();
    }

    /**
     * Getter for secret key
     *
     * @return mixed
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }

    /**
     * Getter for client id
     *
     * @return mixed
     */
    public function getClientId()
    {
        return $this->clientId;
    }

    /**
     * Set the client id
     *
     * @param string $clientId
     * @return ClientCredentials
     */
    public function setClientId($clientId)
    {
        $this->clientId = $clientId;
        return $this;
    }

    /**
     * Set the secret key
     *
     * @param string $secretKey
     * @return ClientCredentials
     */
    public function setSecretKey($secretKey)
    {
        $this->secretKey = $secretKey;
        return $this;
    }
}