<?php
namespace Fifa\ConnectServiceBus\Sdk\Authentication\Model;

/**
 * Class Token
 * @package Fifa\ConnectServiceBus\Sdk\Authentication\Model
 */
class Token
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $expiresIn;

    /**
     * @var string
     */
    private $extExpiresIn;

    /**
     * @var int
     */
    private $expiresOn = 0;

    /**
     * @var string
     */
    private $notBefore;

    /**
     * @var string
     */
    private $resource;

    /**
     * @var string
     */
    private $accessToken;

    /**
     * Constructor
     *
     * @param \stdClass $responseData
     */
    public function __construct(\stdClass $responseData)
    {
        $this->type = isset($responseData->token_type) ? $responseData->token_type : '';
        $this->expiresIn = isset($responseData->expires_in) ? $responseData->expires_in : '';
        $this->extExpiresIn = isset($responseData->ext_expires_in) ? $responseData->ext_expires_in : '';
        $this->notBefore = isset($responseData->not_before) ? $responseData->not_before : '';
        $this->resource = isset($responseData->resource) ? $responseData->resource : '';
        $this->accessToken = isset($responseData->access_token) ? $responseData->access_token : '';

        if (isset($responseData->expires_on)) {
            $this->setExpiresOn($responseData->expires_on);
        }
    }

    /**
     * String representation for the object
     *
     * @return string
     */
    public function __toString()
    {
        return  'Type: ' . $this->getType() . ', ExpiresIn: ' . $this->getExpiresIn() . ', ExtExpiresIn: ' . $this->getExtExpiresIn() .
            ', ExpiresOn: ' . $this->getExpiresOn() . ', NotBefore: ' . $this->getNotBefore() . ', Resource: ' . $this->getResource() .
            '. AccessToken: ' . $this->getAccessToken();
    }

    /**
     * Getter for token type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Getter for AccessToken
     *
     * @return string
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }

    /**
     * Getter for Resource
     *
     * @return string
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * Getter for ExpiresOn
     *
     * @return int
     */
    public function getExpiresOn()
    {
        return $this->expiresOn;
    }

    /**
     * Getter for ExpiresIn
     *
     * @return string
     */
    public function getExpiresIn()
    {
        return $this->expiresIn;
    }

    /**
     * Getter for ExtExpiresIn
     *
     * @return string
     */
    public function getExtExpiresIn()
    {
        return $this->extExpiresIn;
    }

    /**
     * Getter for NotBefore
     *
     * @return string
     */
    public function getNotBefore()
    {
        return $this->notBefore;
    }

    /**
     * @param int $expiresOn
     * @return Token
     */
    public function setExpiresOn($expiresOn)
    {
        if (!is_numeric($expiresOn)) {
            $expiresOn = 0;
        }
        $this->expiresOn = $expiresOn;
        return $this;
    }
}