<?php
namespace Fifa\ConnectServiceBus\Sdk\Authentication;

use Fifa\ConnectServiceBus\Sdk\Authentication\Model\Token;

/**
 * Interface TokenCacheInterface
 * @package Fifa\ConnectServiceBus\Sdk\Authentication
 */
interface TokenCacheInterface
{
    /**
     * Checks whether stored cache is still valid
     *
     * @return bool
     */
    public function isValid();

    /**
     * Returns token object that is stored in cache
     *
     * @return Token
     */
    public function getTokenFromCache();

    /**
     * Store given token object into cache
     *
     * @param Token $token
     * @return TokenCacheInterface
     */
    public function storeCache(Token $token);
}