<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption;
use Fifa\ConnectServiceBus\Sdk\Encryption\Model\PublicCertificate;

/**
 * Interface CertificateCacheInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption
 */
interface CertificateCacheInterface
{
    /**
     * Returns token object that is stored in cache
     *
     * @param string $queueIdentifier
     * @return PublicCertificate
     */
    public function getCertificateFromCache($queueIdentifier);

    /**
     * Store given certificate into cache
     *
     * @param PublicCertificate $certificate
     */
    public function storeCache(PublicCertificate $certificate);
}