<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption;

use Fifa\ConnectServiceBus\Sdk\Encryption\Model\EncryptionResult;
use Fifa\ConnectServiceBus\Sdk\Exception\CryptographyException;

/**
 * Interface CryptographyAlgorithmInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption
 */
interface CryptographyAlgorithmInterface
{
    /**
     * Algorithm version
     *
     * @return string
     */
    public function version();

    /**
     * Encrypts data for specific queueIdentifier
     *
     * @param string $data - Data for encryption
     * @param string $queueIdentifier
     * @return EncryptionResult
     * @throws CryptographyException
     */
    public function encrypt($data, $queueIdentifier);

    /**
     * Decrypts data
     *
     * @param string $data - Encrypted data
     * @param array $properties - Collection of properties that were generated during encryption
     * @return string
     * @throws CryptographyException
     */
    public function decrypt($data, array $properties);
}