<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Decrypt;
use Fifa\ConnectServiceBus\Sdk\Exception\CryptographyException;

/**
 * Interface MessageDecryptionServiceInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Decrypt
 */
interface MessageDecryptionServiceInterface
{
    /**
     * Decrypts given string
     *
     * @param string $data - Encrypted content
     * @param array $properties - Properties that where generated during encryption
     * @return string
     * @throws CryptographyException
     */
    public function decrypt($data, array $properties);
}