<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Decrypt;

use Fifa\ConnectServiceBus\Sdk\Encryption\Model\PrivateCertificate;

/**
 * Class PrivateKeyMemoryStorage
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Decrypt
 */
class PrivateCertificateMemoryStorage implements PrivateCertificateStorageInterface
{
    /**
     * @var PrivateCertificate[]
     */
    private $certificates = array();

    /**
     * Constructor
     *
     * @param PrivateCertificate $privateCertificate
     */
    public function __construct(PrivateCertificate $privateCertificate)
    {
        $this->addNewKey($privateCertificate);
    }

    /**
     * Adds new key into a list of keys
     *
     * @param PrivateCertificate $privateCertificate
     */
    public function addNewKey(PrivateCertificate $privateCertificate)
    {
        $this->certificates[] = $privateCertificate;
    }

    /**
     * Gets latest certificate
     *
     * @return PrivateCertificate
     */
    public function getLatestKey()
    {
        $allKeys = $this->certificates;
        return array_pop($allKeys);
    }

    /**
     * Gets an array of certificates reduced by latest certificate
     *
     * @return PrivateCertificate[]
     */
    public function getPreviousKeys()
    {
        $allKeys = $this->certificates;
        array_pop($allKeys);

        return $allKeys;
    }
}