<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Decrypt;
use Fifa\ConnectServiceBus\Sdk\Encryption\Model\PrivateCertificate;

/**
 * Interface PrivateCertificateStorageInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption
 */
interface PrivateCertificateStorageInterface
{
    /**
     * Gets latest certificate
     *
     * @return PrivateCertificate
     */
    public function getLatestKey();

    /**
     * Gets an array of certificates reduced by latest certificate
     *
     * @return PrivateCertificate[]
     */
    public function getPreviousKeys();
}