<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt;

use Fifa\ConnectServiceBus\Sdk\Exception\CryptographyException;

/**
 * Interface EncryptionServiceInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt
 */
interface EncryptionServiceInterface
{
    /**
     * Encrypts given data
     *
     * @param string $data
     * @param string $queueIdentifier
     * @return string
     * @throws CryptographyException
     */
    public function encrypt($data, $queueIdentifier);
}