<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt;
use Fifa\ConnectServiceBus\Sdk\Encryption\Model\EncryptionResult;
use Fifa\ConnectServiceBus\Sdk\Exception\CryptographyException;

/**
 * Interface MessageEncryptionServiceInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt
 */
interface MessageEncryptionServiceInterface
{
    /**
     * Encrypts given data
     *
     * @param string $data - Content that need to be encrypted
     * @param string $queueIdentifier
     * @throws CryptographyException
     * @return EncryptionResult
     */
    public function encrypt($data, $queueIdentifier);
}