<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt;

use Fifa\ConnectServiceBus\Sdk\Encryption\CertificateCacheInterface;
use Fifa\ConnectServiceBus\Sdk\Encryption\Model\PublicCertificate;

/**
 * Class PublicCertificateProvider
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt
 */
class PublicCertificateProvider implements PublicCertificateProviderInterface
{
    /**
     * @var PublicCertificateSourceInterface
     */
    private $publicKeyProvider;

    /**
     * @var CertificateCacheInterface
     */
    private $certificateCache;

    /**
     * Constructor
     *
     * @param PublicCertificateSourceInterface $publicKeyProvider
     * @param CertificateCacheInterface $certificateCache
     */
    public function __construct(PublicCertificateSourceInterface $publicKeyProvider, CertificateCacheInterface $certificateCache)
    {
        $this->publicKeyProvider = $publicKeyProvider;
        $this->certificateCache = $certificateCache;
    }

    /**
     * Gets certificate
     *
     * @param string $queueIdentifier
     * @return PublicCertificate
     */
    public function get($queueIdentifier)
    {
        $certificate = $this->certificateCache->getCertificateFromCache($queueIdentifier);
        if (is_null($certificate)) {
            $certificate = $this->reload(($queueIdentifier));
        }

        return $certificate;
    }

    /**
     * Reload the certificate
     *
     * @param string $queueIdentifier
     * @return PublicCertificate
     */
    private function reload($queueIdentifier)
    {
        $key = $this->publicKeyProvider->get($queueIdentifier);

        $certificate = new PublicCertificate($queueIdentifier, $key);
        $this->certificateCache->storeCache($certificate);

        return $certificate;
    }
}