<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt;

/**
 * Class PublicKeyMemoryStorage
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt
 */
class PublicKeyMemoryStorage implements PublicKeyStorageInterface
{
    /**
     * @var array
     */
    private static $storage = array();

    /**
     * Gets the key from cache
     *
     * @param string $queueIdentifier
     * @return string|null
     */
    public function get($queueIdentifier)
    {
        return  isset(self::$storage[$queueIdentifier]) ?
                self::$storage[$queueIdentifier] :
                null;
    }

    /**
     * Puts the data into cache
     *
     * @param string $queueIdentifier
     * @param string $rawData
     */
    public function insert($queueIdentifier, $rawData)
    {
        self::$storage[$queueIdentifier] = $rawData;
    }
}