<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt;

/**
 * Interface PublicKeyStorageInterface
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Encrypt
 */
interface PublicKeyStorageInterface
{
    /**
     * Gets the key from cache
     *
     * @param string $queueIdentifier
     * @return string|null
     */
    public function get($queueIdentifier);

    /**
     * Puts the data into cache
     *
     * @param string $queueIdentifier
     */
    public function insert($queueIdentifier, $rawData);
}