<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Model;

/**
 * Class CacheItem
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Model
 */
class CacheItem
{
    /**
     * @var mixed
     */
    private $data;

    /**
     * @var int
     */
    private $expiresOn;

    /**
     * Constructor
     *
     * @param mixed $data
     * @param int $expiresOn - timestamp
     */
    public function __construct($data, $expiresOn)
    {

        $this->data = $data;
        $this->expiresOn = $expiresOn;
    }

    /**
     * String representation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return 'ExpiresOn: ' . $this->expiresOn;
    }

    /**
     * Returns cached data
     *
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Gets the expiry timestamp
     *
     * @return int
     */
    public function getExpiresOn()
    {
        return $this->expiresOn;
    }
}