<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Model;

/**
 * Class PrivateCertificate
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Model
 */
class PrivateCertificate
{
    /**
     * @var string
     */
    private $key;

    /**
     * @var string
     */
    private $password;

    /**
     * Constructor
     *
     * @param string $key
     * @param string $password
     */
    public function __construct($key, $password = '')
    {
        $this->setKey($key);
        $this->setPassword($password);
    }

    /**
     * Gets a key
     *
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Gets a password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Sets a key
     *
     * @param string $key
     * @return PrivateCertificate
     */
    public function setKey($key)
    {
        if (!is_string($key)) {
            throw new \InvalidArgumentException('Provided key needs to be a string.');
        }

        $this->key = $key;
        return $this;
    }

    /**
     * Sets a password
     *
     * @param string $password
     * @return PrivateCertificate
     */
    public function setPassword($password)
    {
        if (!is_string($password)) {
            throw new \InvalidArgumentException('Provided password needs to be a string.');
        }

        $this->password = $password;
        return $this;
    }
}