<?php
namespace Fifa\ConnectServiceBus\Sdk\Encryption\Model;

/**
 * Class PublicCertificate
 * @package Fifa\ConnectServiceBus\Sdk\Encryption\Model
 */
class PublicCertificate
{
    /**
     * @var string
     */
    private $queueIdentifier;

    /**
     * @var string
     */
    private $key;

    /**
     * Constructor
     *
     * @param string $queueIdentifier
     * @param string $key
     */
    public function __construct($queueIdentifier, $key)
    {
        $this->queueIdentifier = $queueIdentifier;
        $this->key = $key;
    }

    /**
     * String representation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return 'OrganisationId: ' . $this->queueIdentifier;
    }

    /**
     * Gets organisation id
     *
     * @return string
     */
    public function getQueueIdentifier()
    {
        return $this->queueIdentifier;
    }

    /**
     * Gets certificate key
     *
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
}