<?php
namespace Fifa\ConnectServiceBus\Sdk\Environment;

use Fifa\ConnectServiceBus\Sdk\Api\Configuration;
use Fifa\ConnectServiceBus\Sdk\Authentication\TokenProviderInterface;

/**
 * Class ApiClientConfiguration
 * @package Fifa\ConnectServiceBus\Sdk\Authentication
 */
class ApiClientConfiguration extends Configuration
{
    /**
     * @var TokenProviderInterface
     */
    private $tokenProvider;

    /**
     * Constructor
     *
     * @param TokenProviderInterface $tokenProvider
     */
    public function __construct(TokenProviderInterface $tokenProvider)
    {
        $this->tokenProvider = $tokenProvider;
        parent::__construct();
    }

    /**
     * Getter for token
     *
     * @return string
     */
    public function getAccessToken()
    {
        return $this->tokenProvider->getToken()->getAccessToken();
    }

    /**
     * @param string $accessToken
     * @return Configuration|void
     * @throws \Exception
     */
    public function setAccessToken($accessToken)
    {
        throw new \Exception('Unsupported operation.');
    }
}