<?php
namespace Fifa\ConnectServiceBus\Sdk\Environment;

use Fifa\ConnectServiceBus\Sdk\Api\Resource\CertificateApi;
use Fifa\ConnectServiceBus\Sdk\Api\Resource\MessageApi;
use Fifa\ConnectServiceBus\Sdk\Authentication\CacheStorageInterface;
use Fifa\ConnectServiceBus\Sdk\Authentication\Model\ClientCredentials;

/**
 * Interface EnvironmentInterface
 * @package Fifa\ConnectServiceBus\Sdk\Environment
 */
interface EnvironmentInterface
{
    /**
     * Creates and returns a message Api object
     *
     * @param ClientCredentials $clientCredentials
     * @return MessageApi
     */
    public function getMessageApi(ClientCredentials $clientCredentials);

    /**
     * Creates and returns a certificate Api object
     *
     * @param ClientCredentials $clientCredentials
     * @return CertificateApi
     */
    public function getCertificateApi(ClientCredentials $clientCredentials);

    /**
     * String representation of the object
     *
     * @return string
     */
    public function __toString();

    /**
     * Getter for service url
     *
     * @return string
     */
    public function getServiceUrl();

    /**
     * Getter for tenant
     *
     * @return string
     */
    public function getTenant();

    /**
     * Getter for cache storage
     *
     * @return CacheStorageInterface
     */
    public function getCacheStorage();

    /**
     * Setter for Curl timeout (CURLOPT_TIMEOUT)
     *
     * @param int $timeoutInSeconds
     * @return EnvironmentInterface
     */
    public function setCurlTimeout($timeoutInSeconds);

    /**
     * Setter for Curl connection timeout (CURLOPT_CONNECTTIMEOUT)
     *
     * @param $timeoutInSeconds
     * @return EnvironmentInterface
     */
    public function setCurlConnectionTimeout($timeoutInSeconds);
}