<?php
namespace Fifa\ConnectServiceBus\Sdk\Environment;

use Fifa\ConnectServiceBus\Sdk\Authentication\AuthenticationResourceBuilderInterface;
use Fifa\ConnectServiceBus\Sdk\Authentication\CacheFileStorage;
use Fifa\ConnectServiceBus\Sdk\Authentication\CacheStorageInterface;
use Fifa\ConnectServiceBus\Sdk\Authentication\ConnectServiceBusAuthenticationResourceBuilder;

/**
 * Class EnvironmentSettings
 * @package Fifa\ConnectServiceBus\Sdk\Environment
 */
class EnvironmentSettings
{
    /**
     * @var AuthenticationResourceBuilderInterface
     */
    private $authenticationResourceBuilder;

    /**
     * @var CacheStorageInterface
     */
    private $cacheStorage;

    /**
     * EnvironmentSettings constructor.
     * @param CacheStorageInterface|string|null $cacheStorage - path to cache folder or CacheStorageInterface instance
     * @param AuthenticationResourceBuilderInterface|null $authenticationResourceBuilder
     */
    public function __construct($cacheStorage = null, AuthenticationResourceBuilderInterface $authenticationResourceBuilder = null)
    {
        if (is_null($authenticationResourceBuilder)) {
            $authenticationResourceBuilder = new ConnectServiceBusAuthenticationResourceBuilder();
        }

        if (is_null($cacheStorage) || is_string($cacheStorage)) {
            $cacheStorage = new CacheFileStorage($cacheStorage);
        }

        if (! $cacheStorage instanceof CacheStorageInterface) {
            throw new \InvalidArgumentException('$cacheStorage needs to be an instance of "CacheStorageInterface"');
        }

        $this->authenticationResourceBuilder = $authenticationResourceBuilder;
        $this->cacheStorage = $cacheStorage;
    }

    /**
     * @return AuthenticationResourceBuilderInterface
     */
    public function getAuthenticationResourceBuilder()
    {
        return $this->authenticationResourceBuilder;
    }

    /**
     * @return CacheStorageInterface
     */
    public function getCacheStorage()
    {
        return $this->cacheStorage;
    }
}