<?php
namespace Fifa\ConnectServiceBus\Sdk\Exception;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;

/**
 * Class FifaConnectServiceBusSdkException
 * @package Fifa\ConnectServiceBus\Sdk\Exception
 */
class FifaConnectServiceBusSdkException extends \Exception
{
    /**
     * @var ApiException
     */
    private $apiException;

    /**
     * Constructor
     *
     * @param ApiException $apiException
     * @param null|string $message
     * @param null|int $code
     */
    public function __construct(ApiException $apiException, $message = null, $code = null)
    {
        $message = is_string($message) ? $message : $apiException->getMessage();
        $code = is_int($code) ? $code : $apiException->getCode();

        parent::__construct($message, $code, $apiException);
        $this->apiException = $apiException;
    }

    /**
     * Gets Response headers
     *
     * @return string
     */
    public function getResponseHeaders()
    {
        return $this->getApiException()->getResponseHeaders();
    }

    /**
     * Gets response body
     *
     * @return mixed
     */
    public function getResponseBody()
    {
        return $this->getApiException()->getResponseBody();
    }

    /**
     * Gets response object
     *
     * @return mixed
     */
    public function getResponseObject()
    {
        return $this->getApiException()->getResponseObject();
    }

    /**
     * @return ApiException
     */
    protected function getApiException()
    {
        return $this->apiException;
    }
}