<?php
namespace Fifa\ConnectServiceBus\Sdk\Exception;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;

/**
 * Class MessageNotFoundException
 * @package Fifa\ConnectServiceBus\Sdk\Exception
 */
class MessageNotFoundException extends FifaConnectServiceBusSdkException
{
    /**
     * Constructor
     *
     * @param ApiException $apiException
     */
    public function __construct(ApiException $apiException)
    {
        $message = sprintf('The service responded with a status code %s: ', $apiException->getCode());
        $message .= 'No message was found with the specified MessageId or LockToken.';

        parent::__construct($apiException, $message, $apiException->getCode());
    }
}