<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Exception\FifaConnectServiceBusSdkException;
use Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler\HandlerInterface;
use Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler\InvalidClientDataHandler;
use Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler\UnauthorizedRequestHandler;

/**
 * Class ApiExceptionHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler
 */
class ApiExceptionHandler
{
    /**
     * Method that creates an exception of type ApiException
     *
     * @param ApiException $apiException
     * @return FifaConnectServiceBusSdkException
     */
    public static function createException(ApiException $apiException)
    {
        $handlers = array_merge(self::getDefaultHandlers(), array_filter(
            func_get_args(),
            function($arg) {
                return ($arg instanceof HandlerInterface);
            }
        ));

        /** @var HandlerInterface $handler */
        foreach ($handlers as $handler) {
            $e = $handler->handle($apiException);
            if ($e instanceof FifaConnectServiceBusSdkException) {
                return $e;
            }
        }

        return new FifaConnectServiceBusSdkException($apiException);
    }

    /**
     * Returns an array of default exception handlers
     *
     * @return HandlerInterface[]
     */
    private static function getDefaultHandlers()
    {
        return array(
            new InvalidClientDataHandler(),
            new UnauthorizedRequestHandler()
        );
    }
}