<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Exception\DataNotFoundException;

/**
 * Class DataNotFoundHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler
 */
class DataNotFoundHandler implements HandlerInterface
{
    /**
     * @var int
     */
    private $errorCode = 404;

    /**
     * Constructor
     *
     * @param int $errorCode
     */
    public function __construct($errorCode = 404)
    {
        $this->errorCode = (int) $errorCode;
    }

    /**
     * String representation of the object
     */
    public function __toString()
    {
        return 'ErrorCode: ' . $this->errorCode;
    }

    /**
     * Method handles a DataNotFoundException
     *
     * @param ApiException $e
     * @return DataNotFoundException|null
     */
    public function handle(ApiException $e)
    {
        if ($e->getCode() == $this->errorCode) {
            return new DataNotFoundException($e);
        }

        return null;
    }
}