<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Api\Model\BadRequestResponseType;
use Fifa\ConnectServiceBus\Sdk\Exception\InvalidClientDataException;

/**
 * Class InvalidClientDataHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler
 */
class InvalidClientDataHandler implements HandlerInterface
{
    /**
     * Method handles an InvalidClientDataException
     *
     * @param ApiException $e
     * @return InvalidClientDataException|null
     */
    public function handle(ApiException $e)
    {
        if ($e->getCode() == 400 && $e->getResponseObject() instanceof BadRequestResponseType) {
            return new InvalidClientDataException($e, $e->getResponseObject());
        }
        
        return null;
    }
}