<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Exception\MessageNotFoundException;

/**
 * Class MessageNotFoundHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler
 */
class MessageNotFoundHandler implements HandlerInterface
{
    /**
     * Method handles an MessageNotFoundException
     *
     * @param ApiException $e
     * @return MessageNotFoundException|null
     */
    public function handle(ApiException $e)
    {
        if ($e->getCode() == 404) {
            return new MessageNotFoundException($e);
        }

        return null;
    }
}