<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Exception\NoMessagesAvailableException;

/**
 * Class NoMessagesAvailableHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler
 */
class NoMessagesAvailableHandler implements HandlerInterface
{
    /**
     * Method handles an NoMessagesAvailableException
     *
     * @param ApiException $e
     * @return NoMessagesAvailableException|null
     */
    public function handle(ApiException $e)
    {
        if ($e->getCode() == 204) {
            return new NoMessagesAvailableException($e);
        }

        return null;
    }
}