<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Exception\FifaConnectServiceBusSdkException;
use Fifa\ConnectServiceBus\Sdk\Exception\QueueExistsException;
use Fifa\ConnectServiceBus\Sdk\FifaConnectServiceBusClient;

/**
 * Class QueueAlreadyExistsHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler
 */
class QueueAlreadyExistsHandler implements HandlerInterface
{
    /**
     * Method handles an QueueExistsException
     *
     * @param ApiException $e
     * @return FifaConnectServiceBusSdkException|null
     * @throws QueueExistsException
     */
    public function handle(ApiException $e)
    {
        if ($e->getCode() == FifaConnectServiceBusClient::HTTP_CODE_CONFLICT)
        {
            return new QueueExistsException($e, 'Queue already exists');
        }

        return null;
    }
}