<?php
namespace Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler;

use Fifa\ConnectServiceBus\Sdk\Api\ApiException;
use Fifa\ConnectServiceBus\Sdk\Exception\QueueNotFoundException;

/**
 * Class QueueNotFoundHandler
 * @package Fifa\ConnectServiceBus\Sdk\ExceptionHandler\Handler
 */
class QueueNotFoundHandler implements HandlerInterface
{
    /**
     * @var int
     */
    private $errorCode = 404;

    /**
     * Constructor
     *
     * @param int $errorCode
     */
    public function __construct($errorCode = 404)
    {
        $this->errorCode = (int) $errorCode;
    }

    /**
     * String representation of the object
     */
    public function __toString()
    {
        return 'ErrorCode: ' . $this->errorCode;
    }

    /**
     * Method handles a QueueNotFoundException
     *
     * @param ApiException $e
     * @return QueueNotFoundException|null
     */
    public function handle(ApiException $e)
    {
        if ($e->getCode() == $this->errorCode) {
            return new QueueNotFoundException($e);
        }

        return null;
    }
}