<?php
namespace Fifa\ConnectServiceBus\Sdk;

use Fifa\ConnectServiceBus\Sdk\Exception\AuthenticationException;
use Fifa\ConnectServiceBus\Sdk\Exception\DataNotFoundException;
use Fifa\ConnectServiceBus\Sdk\Exception\FifaConnectServiceBusSdkException;
use Fifa\ConnectServiceBus\Sdk\Exception\InvalidClientDataException;
use Fifa\ConnectServiceBus\Sdk\Exception\UnauthorizedException;

/**
 * Interface FifaConnectServiceBusCertificateClientInterface
 * @package Fifa\ConnectServiceBus\Sdk
 */
interface FifaConnectServiceBusCertificateClientInterface
{
    /**
     * Upload a public certificate to central infrastructure.
     *
     * @param string $rawData - string containing certificate data
     *
     * @throws FifaConnectServiceBusSdkException
     * @throws InvalidClientDataException
     * @throws UnauthorizedException
     * @throws AuthenticationException
     */
    public function uploadCertificate($rawData);

    /**
     * Gets a byte array that contains data from an X.509 certificate.
     *
     * @param string $queueIdentifier
     * @return string
     *
     * @throws FifaConnectServiceBusSdkException
     * @throws InvalidClientDataException
     * @throws DataNotFoundException
     * @throws UnauthorizedException
     * @throws AuthenticationException
     */
    public function downloadCertificate($queueIdentifier);
}