<?php
namespace Fifa\ConnectServiceBus\Sdk\Utils;

use Fifa\ConnectServiceBus\Sdk\Authentication\CacheStorageInterface;

/**
 * Class Cache
 * @package Fifa\ConnectServiceBus\Sdk\Utils
 */
class Cache
{
    /**
     * @var int
     */
    private $validLimit;

    /**
     * @var CacheStorageInterface
     */
    private $cacheStorage;

    /**
     * Cache constructor.
     * @param CacheStorageInterface $cacheStorage
     */
    public function __construct(CacheStorageInterface $cacheStorage)
    {
        $this->cacheStorage = $cacheStorage;
    }

    /**
     * Returns string representation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return 'ValidLimit: ' . $this->getValidLimit();
    }

    /**
     * Sets validity limit
     *
     * @param int $validLimit
     * @return Cache
     */
    public function setValidLimit($validLimit)
    {
        $this->validLimit = $validLimit;
        return $this;
    }

    /**
     * Gets validity limit
     *
     * @return int
     */
    public function getValidLimit()
    {
        return $this->validLimit;
    }

    /**
     * Gets data from cache.
     *
     * @param string $filenameKey
     * @return mixed|null
     */
    protected function getFromCache($filenameKey)
    {
        $rawData = $this->cacheStorage->get($filenameKey);
        $unserializedData = unserialize($rawData);

        return $unserializedData;
    }

    /**
     * Store given object into cache
     *
     * @param string $filenameKey
     * @param mixed $object
     */
    protected function putIntoCache($object, $filenameKey)
    {
        $serializedData = serialize($object);
        $this->cacheStorage->put($serializedData, $filenameKey);
    }
}