<?php
namespace Fifa\ConnectServiceBus\Sdk\Utils;

/**
 * Class File
 * @package Fifa\ConnectServiceBus\Sdk\Utils
 */
class File
{
    /**
     * Overrides default file_get_contents function by checking that given file exists
     *
     * @param string $filename
     * @param bool|false $use_include_path
     * @param null $context
     * @param int $offset
     * @return string
     */
    public static function getContents($filename, $use_include_path = false, $context = null, $offset = 0)
    {
        if (!file_exists($filename)) {
            throw new \InvalidArgumentException('File "' . $filename . '" does not exist.');
        }

        return file_get_contents($filename, $use_include_path, $context, $offset);
    }
}